begin
  require "FileUtils" if FIleUtils == nil
rescue Exception
end


# Fonctions supplmentaires pour la classe File
class File




 
  # Fonction permettant d'atribuer une extension  un nom de fichier
  #  Entre : le nom du fichier, l'extension
  #  Sortie : le nom du fichier avec l'extension
  #
  # L'extension doit tre de la forme "xxx" et non pas ".xxx".
  # Notez que vous pouvez spcifier une extension d'autant de caractres que vous le souhaitez
  # Si la bonne extension tait dj spcifie, mme avec des majuscules, celle-ci est garde
  #
  # Quelques exemples de la fonction pour bien comprendre :
  #  File.forcer_extension("lisez-moi", "txt") => "lisez-moi.txt"
  #  File.forcer_extension("lisez-moi.", "txt") => "lisez-moi.txt"
  #  File.forcer_extension("lisez-moi.txt", "txt") => "lisez-moi.txt"
  #  File.forcer_extension("lisez-moi.TXT", "txt") => "lisez-moi.TXT"
  #  File.forcer_extension("lisez-moi.important", "txt") => "lisez-moi.important.txt"
  #  File.forcer_extension("lisez-moi", "superfichiertexte") => "lisez-moi.superfichiertexte"
  #
  # v1.0
  def self.forcer_extension_v1(filename, extension)

    # On positionne l'extension du fichier
    pos = filename.rindex(".")

    # S'il y a une extension, on la vrifie
    if !pos.nil?
      ext = filename[pos+1...filename.size].downcase
      # Si ce n'est pas l'extension spcifie, on la rajoute
      if ext.downcase != extension.downcase
        # On vrifie que le dernier caractre du nom de fichier ne soit pas dj un "."
        if filename[filename.size-1..filename.size-1] != "."
          filename += "."+extension
        else
          filename += extension
        end
      end
    else
      # S'il n'y a pas d'extension, on se contente de la rajouter
      filename += "."+extension
    end

    # On renvoie le nom du fichier avec son extension correcte
    return filename

  end


  def self.forcer_extension(filename, extension)

    # On positionne l'extension du fichier
    reg = Regexp.new("\\.#{extension}$", true)

    if reg.match(filename).nil? == false
      return filename
    end

    # On regarde s'il y a une extension
    if File.extname(filename) != ""
      # On remplace l'extension
      return filename.sub(/\.[^\.]+$/, "."<<extension)
    end

    # On renvoie le nom du fichier avec son extension correcte
    return filename+"."+extension

  end




  def self.remplacer_extension(filename, ext)

    pos = filename.rindex('.')
    if pos.nil?
      return filename+'.'+ext
    end

    act_ext = filename[pos+1..filename.size]

    if act_ext.downcase != ext.downcase
      return filename[0..pos]+ext
    else
      return filename
    end

  end

  


  # Renvoie le nom de fichier sans l'extension
  def self.no_extname(filename)
    ext = File.extname(filename)
    return filename[0...filename.size-ext.size]
  end

  
  def self.crc32(file_name)
    c = DA::file_read(file_name, "rb")
    Zlib.crc32(c ,0).to_s(16)
  end


end